<?php

namespace Database\Seeders;

use Carbon\Carbon;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ItemMasterSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $now = Carbon::now();

        DB::table('item_masters')->insert([
            [
                'ItemCode'       => 'ITEM001',
                'Description'    => 'Sample Widget A',
                'UOM'            => 'PCS',
                'Price'          => 120.50,
                'Cost'           => 80.00,
                'Inventory'      => 50,
                'QtyInPO'        => 10,
                'QtyInSO'        => 5,
                'QtyInTO'        => 0,
                'Item_No'        => 'NP-1001',
                'VariantCode'    => null,
                'QtyinTransferIn'=> 0,
                'QtyinTransferOut'=> 0,
                'ConvFactor'     => 1.0,
                'Base_UOM'       => 'PCS',
                'BusinessUnitid' => 'BU-01',
                'CompanyId'      => 'LE-01',
                'action_flag'    => 'is_add', // add/edit/delete
                'created_at'     => $now,
                'updated_at'     => $now,
            ],
            [
                'ItemCode'       => 'ITEM002',
                'Description'    => 'Gadget B',
                'UOM'            => 'BOX',
                'Price'          => 450.00,
                'Cost'           => 300.00,
                'Inventory'      => 25,
                'QtyInPO'        => 5,
                'QtyInSO'        => 2,
                'QtyInTO'        => 1,
                'Item_No'        => 'NP-1002',
                'VariantCode'    => null,
                'QtyinTransferIn'=> 2,
                'QtyinTransferOut'=> 0,
                'ConvFactor'     => 12.0,
                'Base_UOM'       => 'PCS',
                'BusinessUnitid' => 'BU-02',
                'CompanyId'      => 'LE-02',
                'action_flag'    => 'is_edit',
                'created_at'     => $now,
                'updated_at'     => $now,
            ],
            [
                'ItemCode'       => 'ITEM003',
                'Description'    => 'Device C',
                'UOM'            => 'SET',
                'Price'          => 999.99,
                'Cost'           => 700.00,
                'Inventory'      => 10,
                'QtyInPO'        => 0,
                'QtyInSO'        => 0,
                'QtyInTO'        => 0,
                'Item_No'        => 'NP-1003',
                'VariantCode'    => null,
                'QtyinTransferIn'=> 0,
                'QtyinTransferOut'=> 0,
                'ConvFactor'     => 1.0,
                'Base_UOM'       => 'SET',
                'BusinessUnitid' => 'BU-03',
                'CompanyId'      => 'LE-01',
                'action_flag'    => 'is_delete',
                'created_at'     => $now,
                'updated_at'     => $now,
            ],
        ]);
    }
}
