<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\ItemMaster;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class ItemMasterApiController extends Controller
{
    public function bulkStoreOrUpdate(Request $request)
    {

        if (!is_array($request->all())) {
            return response()->json([
                "isSuccess"    => false,
                "responseData" => [],
                "message"      => "Invalid request format",
                "errorInfo"    => null
            ], 400);
        }

        $responseData = [];

        foreach ($request->all() as $index => $item) {

            $validator = Validator::make($item, [
                'ItemCode'       => 'required|string',
                'flag'           => 'nullable|in:delete',
                'Description'    => 'required_unless:flag,delete|string',
                'UOM'            => 'required_unless:flag,delete|string',
                'Item_No'        => 'required_unless:flag,delete|string',
                'ConvFactor'     => 'required_unless:flag,delete|numeric',
                'Base_UOM'       => 'required_unless:flag,delete|string',
                //'BusinessUnitid' => 'required_unless:flag,delete|string',
                'CompanyId'      => 'required_unless:flag,delete|string',
                'is_weighted_item' => 'required_unless:flag,delete|in:0,1'
            ]);

            if ($validator->fails()) {
                $responseData[] = [
                    "errorMessage" => $validator->errors()->first(),
                    "status"       => false,
                    "ItemCode"     => $item['ItemCode'] ?? null
                ];
                continue;
            }

            $itemCode = $item['ItemCode'];
            $flag     = $item['flag'] ?? null;

            try {
                if ($flag === 'delete') {
                    $deleted = ItemMaster::where('ItemCode', $itemCode)->delete();
                    $responseData[] = [
                        "errorMessage" => $deleted ? null : "Item not found",
                        "status"       => (bool) $deleted,
                        "ItemCode"     => $itemCode
                    ];
                    continue;
                }
                
                $itemData = [
                    'Description'    => $item['Description'] ?? '',
                    'UOM'            => $item['UOM'] ?? '',
                    'Item_No'        => $item['Item_No'] ?? '',
                    'ConvFactor'     => $item['ConvFactor'] ?? '',
                    'Base_UOM'       => $item['Base_UOM'] ?? '',
                    'BusinessUnitid' => $item['BusinessUnitid'] ?? '',
                    'CompanyId'      => $item['CompanyId'] ?? '',
                    'IsWeightedItem' => $item['is_weighted_item'] ?? ''
                ];

                $existing = ItemMaster::where('ItemCode', $itemCode)->first();

                if ($existing) {
                    $itemData['action_flag'] = 'is_edit';
                    $existing->update($itemData);
                    $responseData[] = [
                        "errorMessage" => null,
                        "status"       => true,
                        "ItemCode"     => $itemCode
                    ];
                } else {
                    $itemData['action_flag'] = 'is_add';
                    $created = ItemMaster::create(array_merge(['ItemCode' => $itemCode], $itemData));
                    $responseData[] = [
                        "errorMessage" => $created ? null : "Failed to create item",
                        "status"       => (bool) $created,
                        "ItemCode"     => $itemCode
                    ];
                }
            } catch (\Exception $e) {
                $responseData[] = [
                    "errorMessage" => $e->getMessage(),
                    "status"       => false,
                    "ItemCode"     => $itemCode
                ];
            }
        }

        return response()->json([
            "isSuccess"    => true,
            "responseData" => $responseData,
            "message"      => null,
            "errorInfo"    => null
        ]);
    }
}
