<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use App\Models\ApiToken;
use Carbon\Carbon;

class ApiTokenController extends Controller
{
    public function generateToken(Request $request)
    {
        $request->validate([
            'username' => 'required|string',
            'password' => 'required|string',
        ]);

        $username = config('services.token_api.username');
        $password = config('services.token_api.password');

        if ($request->username !== $username || $request->password !== $password) {
            return response()->json([
                'isSuccess'    => false,
                'responseData' => [],
                'message'      => 'Unauthorized',
                'errorInfo'    => 'Invalid username or password',
            ], 401);
        }

        $token = hash('sha256', Str::random(40));
        $expiresAt = Carbon::now()->addMinutes(10);

        ApiToken::create([
            'token' => $token,
            'expires_at' => $expiresAt,
        ]);

        return response()->json([
            'isSuccess' => true,
            'token' => $token,
            'expires_at' => $expiresAt->toDateTimeString(),
        ]);
    }
}
